//=============================================================================
// MSTerminalWindow.
//=============================================================================
class MSTerminalWindow expands MenuUIWindow;

var MenuUIActionButtonWindow okButton;
var MenuUIActionButtonWindow exitButton;
var MenuUIEditWindow DamageWindow;
var MenuUIEditWindow FireRateWindow;
var MenuUIEditWindow SelTitleWindow;
var MenuUIHeaderWindow winText;
var localized string okButtonText;
var localized string exitButtonText;
var MSUtilityGun _windowOwner;
var name SelCamera;
var string SelTitle;
var name SelTurret;

struct sViewInfo
{
	var() localized string	titleString;
	var() name				cameraTag;
	var() name				turretTag;
	var() name				doorTag;
};

var localized sViewInfo ShitHolder;

event InitWindow()
{
   local Window W;

   Super.InitWindow();

   winClient.SetBackground(Texture'DeusExUI.MaskTexture');
   winClient.SetBackgroundStyle(DSTY_Modulated);

   W = winClient.NewChild(Class'Window');
   W.SetSize(ClientWidth, ClientHeight);
   W.SetBackground(Texture'DeusExUI.MaskTexture');
   W.SetBackgroundStyle(DSTY_Modulated);
   W.Lower();

   DamageWindow = CreateMenuEditWindow(60, 15, 70, 30, winClient);
   FireRateWindow = CreateMenuEditWindow(130, 15, 70, 30, winClient);
   SelTitleWindow = CreateMenuEditWindow(60, 45, 70, 30, winClient);

   okButton = winButtonBar.AddButton(okButtonText, HALIGN_Right);
   exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);

  if (Player.Weapon.IsA('MSUtilityGun'))
   {
     _WindowOwner = MSUtilityGun(Player.Weapon);
   }

  if ((_WindowOwner != None) && (_WindowOwner.Selected.IsA('UtilityComputerSecurity')))
  {
   SelCamera = UtilityComputerSecurity(_WindowOwner.Selected).UTViews[_WindowOwner.ViewPointMode].cameraTag;
   SelTurret = UtilityComputerSecurity(_WindowOwner.Selected).UTViews[_WindowOwner.ViewPointMode].turretTag;
   SelTitle = UtilityComputerSecurity(_WindowOwner.Selected).UTViews[_WindowOwner.ViewPointMode].titleString;
  }

   DamageWindow.setText(""$SelCamera$"");
   FireRateWindow.setText(""$SelTitle$"");
   SelTitleWindow.setText(""$SelTurret$"");
   SetTitle("Camera, Title, Turret");
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch( buttonPressed )
	{
		case okButton:

			_WindowOwner.setTerminal(DamageWindow.GetText(), FireRateWindow.GetText(), SelTitleWindow.GetText());
			root.PopWindow();
			bHandled = True;
			break;

		case exitButton:
			// Do stuff
			root.PopWindow();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	return bHandled;
}

defaultproperties
{
     okButtonText="Ok"
     exitButtonText="Cancel"
     ClientWidth=350
     ClientHeight=85
     clientTextures(0)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_2'
     textureRows=1
     textureCols=2
     bActionButtonBarActive=True
     bUsesHelpWindow=False
     winShadowClass=Class'DeusEx.MenuUIMessageBoxShadowWindow'
}
